using log4net;
using Microsoft.Azure.WebJobs;
using Microsoft.Azure.WebJobs.Extensions.Http;
using System;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using VA.PPMS.Context;
using VA.PPMS.IWS.BatchService.Interface;
using VA.PPMS.IWS.Common;

namespace VA.PPMS.IWS.Functions
{
    public static class DasOperationOutcome
    {
        [FunctionName("DasOperationOutcome")]
        public static async Task<HttpResponseMessage> Run([HttpTrigger(AuthorizationLevel.Anonymous, "post", Route = "DasOperationOutcome/v1")]HttpRequestMessage req,
            [Inject]IBatchService batchService,
            [Inject] ILog logger)
        {
            try
            {
                logger.Info("@@@@@ Start DasOperationOutcome http function @@@@@");

                var payload = await req.Content.ReadAsStringAsync();
                var message = new DasMessage(payload);
                var success = bool.Parse(message.Content);

                if (success) await batchService.IncrementBatchStatus(message, "DAS Operation Outcome Request processed.");
                else await batchService.UpdateBatch(message, "DAS Operation Outcome Request processed.", (int)ppms_batch_StatusCode.Failed);

                logger.Info("@@@@@ End DasOperationOutcome http function @@@@@");

                return req.CreateResponse(HttpStatusCode.Created);
            }
            catch (Exception ex)
            {
                logger.Error("An error occurred in the DasOperationOutcome Function API: ", ex);
                return req.CreateErrorResponse(HttpStatusCode.InternalServerError, "An error occurred in the DasOperationOutcome Function API: ", ex);
            }
        }
    }
}